<?php
namespace Elementor; 

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly	
}

/**
 *  Steps Box
*/
 
class Boldman_Stepsbox2_Widget extends Widget_Base{

	public function get_name() {
		return 'tm_staticbox2_element';
	}

	public function get_title() {
		return esc_attr__( 'Static Icon Box', 'boldman' );
	}

	public function get_icon() {
		return ' eicon-post-slider';
	}

	public function get_categories() {
		return [ 'boldman_category' ];
	}

	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
	}

	protected function register_controls() {

		$this->start_controls_section(
			'heading_section',
			[
				'label' => esc_attr__( 'General', 'boldman' ),
			]
		);
		
		$this->add_control(
			'style',
			[
				'label'			=> esc_attr__( 'Select StepBox Style', 'boldman' ),
				'description'	=> esc_attr__( 'Select StepBox style.', 'boldman' ),
				'type' => Controls_Manager::SELECT,
				'label_block'	=> true,
				'options' => [
					'style1'	=> esc_attr( 'Style 1' ),
					'style2'	=> esc_attr( 'Style 2' ),
				],
				'default' => esc_attr( 'style1' ),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'data_section',
			[
				'label' => esc_attr__( 'Boxes Content', 'boldman' ),
			]
        );

		$repeater = new Repeater();

		$repeater_inner = new Repeater();

		 $repeater_inner->add_control(
			'label2',
			[
				'label' => esc_attr__( 'Box Title', 'boldman' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_attr__( 'Box Title', 'boldman' ),
				'placeholder' => esc_attr__( 'Box Title', 'boldman' ),
				'label_block' => true,
			]
		 );

		$repeater->add_control(
			'icon_type',
			[
				'label' => esc_attr__( 'Icon Type', 'boldman' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'icon'	=> esc_attr__( 'Icon', 'boldman' ),
					'image'	=> esc_attr__( 'Image', 'boldman' ),
				],
				'default' => esc_attr( 'icon' ),
			]
		);
		
		$repeater->add_control(
			'icon',
			[
				'label' => __( 'Icon', 'boldman' ),
				'type' => \Elementor\Controls_Manager::ICONS,
                'condition' => [
                    'icon_type' => 'icon',
                ]
            ]

		);
		
		 $repeater->add_control(
			'icon_image',
			[
				'label' => __( 'Select Image for Icon', 'boldman' ),
				'description' => __( 'image will appear at icon position', 'boldman' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image',
                ]
			]
		);


		$repeater->add_control(
			'label',
			[
				'label' => esc_attr__( 'Box Title', 'boldman' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_attr__( 'Box Title', 'boldman' ),
				'placeholder' => esc_attr__( 'Box Title', 'boldman' ),
				'label_block' => true,
			]
		);
		
		
		$repeater->add_control(
			'smalltext',
			[
				'label' => esc_attr__( 'Box Content', 'boldman' ),
				'default' => esc_attr__( 'Box Content', 'boldman' ),
				'placeholder' => esc_attr__( 'Box Content', 'boldman' ),
				'type' => Controls_Manager::TEXTAREA,
				'show_label' => true,
			]
		);

		$repeater->add_control(
				'cur_symbol',
				[
					'label'         => esc_attr__( 'Currency symbol', 'boldman' ),
					'type'          => Controls_Manager::TEXT,
					'description'   => esc_attr__( 'Enter currency symbol', 'boldman' ),
				]
			);

		$repeater->add_control(
				'price',
				[
					'label'         => esc_attr__( 'Price', 'boldman' ),
					'type'          => Controls_Manager::TEXT,
					'description'   => esc_attr__( 'Enter Price.', 'boldman' ),
				]
			);

		$repeater->add_control(
				'cur_symbol_position',
				[
					'label'			=> esc_html__( 'Currency Symbol position', 'boldman' ),
					'description'	=> esc_html__( 'Select currency position.', 'boldman' ),
					'type'			=> Controls_Manager::SELECT,
					'default'		=> 'after',
					'options' => [
						'after'		=> __( 'After Price', 'boldman' ),
						'before'	=> __( 'Before Price', 'boldman' ),
					],
				]
			);
		$repeater->add_control(
				'price_frequency',
				[
					'label'         => esc_attr__( 'Price Frequency', 'boldman' ),
					'type'          => Controls_Manager::TEXT,
					'description'   => esc_attr__( 'Enter currency frequency like "Monthly", "Yearly" or "Weekly" etc.', 'boldman' ),
					'separator'     => 'after',
				]
			);

		$repeater->add_control(
				'lines',
				[
					'label'			=> esc_attr__( 'Each Line (Features)', 'boldman' ),
					'description'	=> esc_attr__( 'Enter features that will be shown in spearate lines.', 'boldman' ),
					'type'			=> Controls_Manager::REPEATER,
					'fields'		=> $repeater_inner->get_controls(),
					
				]
			);

		$repeater->add_control(
				'_btn_text',
				[
					'label'         => esc_attr__( 'Button Text', 'boldman' ),
					'type'          => Controls_Manager::TEXT,
					'description'   => esc_attr__( 'Like "Read More" or "Buy Now".', 'boldman' ),
				]
			);
			
		$repeater->add_control(
				'_btn_link',
				[
					'label'         => esc_attr__( 'Button Link', 'boldman' ),
					'type'          => Controls_Manager::URL,
					'description'   => esc_attr__( 'Set link for button', 'boldman' ),
					'separator'     => 'after',
				]
			);

        $this->add_control(
			'boxes',
			[
				'label'		=> esc_attr__( 'Boxes', 'boldman' ),
				'type'		=> Controls_Manager::REPEATER,
				'fields'	=> $repeater->get_controls(),
				'default'	=> [
					[
						'image'		=> get_template_directory_uri() . '/images/placeholder.png',
						'label'		=> esc_attr__( 'This is first box', 'boldman' ),
						'smalltext'	=> esc_attr__( 'This is small description', 'boldman' ),
					],
					[
						'image'		=> get_template_directory_uri() . '/images/placeholder.png',
						'label'		=> esc_attr__( 'This is second box', 'boldman' ),
						'smalltext'	=> esc_attr__( 'This is small description', 'boldman' ),
					],
				],
				'title_field' => '{{{ label }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'appearance_section',
			[
				'label' => esc_attr__( 'Box Design', 'boldman' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
	
		$this->add_control(
			'column',
			[
				'label'			=> esc_attr__( 'Select Column', 'boldman' ),
				'description'	=> esc_attr__( 'Select column.', 'boldman' ),
				'type' => Controls_Manager::SELECT,
				'label_block'	=> true,
				'default'		=> 'one',
				'options'		=> [
					'one'				=> esc_attr__( 'One Column', 'boldman' ),
					'two'				=> esc_attr__( 'Two Column', 'boldman' ),
					'three'				=> esc_attr__( 'Three Column', 'boldman' ),
					'four'				=> esc_attr__( 'Four Column', 'boldman' ),
					'five'				=> esc_attr__( 'Five Column', 'boldman' ),
					'six'				=> esc_attr__( 'Six Column', 'boldman' ),
				],
			]
		);
		
		$this->add_control(
			'view-type',
			[
				'label'			=> esc_attr__( 'Box View', 'boldman' ),
				'description'	=> esc_attr__( 'Select box view. Show as normal row and column or show with carousel effect.', 'boldman' ),
				'type' => Controls_Manager::SELECT,
				'label_block'	=> true,
				'default'		=> 'carousel',
				'options'		=> [
					'default'	=> esc_attr__( 'Row and Column', 'boldman' ),
					'carousel'	=> esc_attr__( 'Carousel effect', 'boldman' ),
				]
			]
		);

		$this->add_control(
			'carousel_options',
			[
				'label' => esc_attr__( 'Carousel Settings', 'boldman' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'view-type' => 'carousel',
				]
			]
		);

		$this->add_control(
			'tm-autoplayspeed',
			[
				'label'			=> esc_attr__( 'Carousel: autoplaySpeed', 'boldman' ),
				'description'	=> esc_attr__( 'Carousel Effect: Slide/Fade animation speed.', 'boldman' ),
				'type'			=> Controls_Manager::TEXT,
				'default'		=> '4500',
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);
		
		$this->add_control(
			'tm-loop',
			[
				'label'			=> esc_attr__( 'Carousel: Loop Item', 'boldman' ),
				'description'	=> esc_attr__( 'Carousel Effect: Infinite loop sliding.', 'boldman' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> '0',
				'options'		=> [
					'1'				=> esc_attr__( 'Yes', 'boldman' ),
					'0'				=> esc_attr__( 'No', 'boldman' ),
				],
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);

		$this->add_control(
			'tm-autoplay',
			[
				'label'			=> esc_attr__( 'Carousel: Autoplay', 'boldman' ),
				'description'	=> esc_attr__( 'Carousel Effect: Enable/disable Autoplay', 'boldman' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> '0',
				'options'		=> [
					'1'				=> esc_attr__( 'Yes', 'boldman' ),
					'0'				=> esc_attr__( 'No', 'boldman' ),
				],
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);

		$this->add_control(
			'tm-centermode',
			[
				'label'			=> esc_attr__( 'Carousel: centerMode', 'boldman' ),
				'description'	=> esc_attr__( 'Enables centered view with partial prev/next slides. Use with odd numbered slidesToShow counts.', 'boldman' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> '0',
				'options'		=> [
					'1'				=> esc_attr__( 'Yes', 'boldman' ),
					'0'				=> esc_attr__( 'No', 'boldman' ),
				],
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);

		$this->add_control(
			'carousel_centerpadding',
			[
				'label'			=> esc_attr__( 'Carousel: centerPadding', 'boldman' ),
				'description'	=> esc_attr__( 'Carousel center effect padding.', 'boldman' ),
				'type'			=> Controls_Manager::TEXT,
				'default'		=> '300'
			]
		);


		$this->add_control(
			'carousel_nav',
			[
				'label'			=> esc_attr__( 'Carousel: Next/Prev Arrows', 'boldman' ),
				'description'	=> esc_attr__( 'Carousel Effect: Show dots navigation.', 'boldman' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> '0',
				'options'		=> [
					'1'				=> esc_attr__( 'Yes', 'boldman' ),
					'0'				=> esc_attr__( 'No', 'boldman' ),
				],
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);

		$this->add_control(
			'carousel_arrowtype',
			[
				'label'			=> esc_attr__( 'Carousel:Button Type', 'boldman' ),
				'description'	=> esc_attr__( 'Carousel button type.', 'boldman' ),
				'type'			=> Controls_Manager::SELECT,
				'options'		=> [
					'square'			=> esc_attr__( 'Square', 'boldman' ),
					'round'				=> esc_attr__( 'Round', 'boldman' ),
				],
				'default'		=> 'square',
				'condition'		=> [
					'view-type'		=> 'carousel',
					'carousel_nav'		=> '1',
				]
			]
		);
		
		$this->add_control(
			'carousel_dots',
			[
				'label'			=> esc_attr__( 'Carousel: dots', 'boldman' ),
				'description'	=> esc_attr__( 'Carousel Effect: Show dots navigation.', 'boldman' ),
				'type'			=> Controls_Manager::SELECT,
				'options'		=> [
					'1'				=> esc_attr__( 'Yes', 'boldman' ),
					'0'				=> esc_attr__( 'No', 'boldman' ),
				],
				'default'		=> '1',
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);
		
		$this->add_control(
			'carousel_slidestoscroll',
			[
				'label'			=> esc_attr__( 'Carousel: slidesToScroll', 'boldman' ),
				'description'	=> esc_attr__( '# of slides to scroll', 'boldman' ),
				'type'			=> Controls_Manager::SELECT,
				'options'		=> [
					'1'				=> esc_attr__( '1 Slide', 'boldman' ),
					'column'		=> esc_attr__( 'Same as column', 'boldman' ),
				],
				'default'		=> '1',
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);

		$this->end_controls_section();

		
	}

	protected function render() {

		$settings	= $this->get_settings_for_display();
		extract($settings);
		$return = '';
		$link_html = '';
		$image_html		= '' ;
    
		$start_div = ttm_element_container( array(
			'position'	=> 'start',
			'cpt'		=> 'static-iconbox',
			'data'		=> $settings
		) );

		echo themetechmount_wp_kses($start_div);


		?>

			<?php
			tm_heading_subheading($settings, true);
		?>

		<div class="themetechmount-boxes-row-wrapper row multi-columns-row">

		<?php
			$col_start_div	= '';
			$col_end_div	= '';
			if( !empty($boxes) ){
				switch( count($boxes) ){
					case 1:
						$col_start_div	= '<div class="tm-box-col-wrapper col-lg-12 col-sm-12 col-md-12 col-xs-12">';
						$col_end_div	= '</div>';
						break;

					case 2:
						$col_start_div	= '<div class="tm-box-col-wrapper col-lg-6 col-sm-6 col-md-6 col-xs-12">';
						$col_end_div	= '</div>';
						break;

					case 3:
						$col_start_div	= '<div class="tm-box-col-wrapper col-lg-4 col-sm-6 col-md-4 col-xs-12">';
						$col_end_div	= '</div>';
						break;

					case 4:
						$col_start_div	= '<div class="tm-box-col-wrapper col-lg-3 col-sm-6 col-md-3 col-xs-12">';
						$col_end_div	= '</div>';
						break;

					case 5:
						$col_start_div	= '<div class="tm-box-col-wrapper col-lg-20percent col-sm-4 col-md-4 col-xs-12">';
						$col_end_div	= '</div>';
						break;
						
					case 6:
						$col_start_div	= '<div class="tm-box-col-wrapper col-lg-2 col-sm-4 col-md-4 col-xs-12">';
						$col_end_div	= '</div>';
						break;
				}
			} ?>

		<?php

		foreach( $settings['boxes'] as $box ){

			$smalltext_html	= ( !empty($box['smalltext']) ) ? '<div class="tm-infobox-desc">'.esc_html($box['smalltext']).'</div>' : '' ;
			$label_html		= ( !empty($box['label']) ) ? '<div class="tm-box-title"><h5>'.esc_html($box['label']).'</h5></div>' : '' ;
		
            $currency_symbol = ( !empty($box['cur_symbol']) ) ? '<div class="tm-staticbox-cur-symbol-'.$box['cur_symbol_position'].'">'.esc_html($box['cur_symbol']).'</div>' : '' ;
            $price          = ( !empty($box['price']) ) ? '<div class="tm-staticbox-price">'.esc_html($box['price']).'</div>' : '' ;

			$frequency = ( !empty($box[$col.'price_frequency']) ) ? '<div class="tm-staticbox-frequency">'.esc_html($box['price_frequency']).'</div>' : '' ;

			$price = ( !empty($box[$col.'cur_symbol_position']) && $box[$col.'cur_symbol_position']=='before' ) ? $currency_symbol.' '.$price : $price.' '.$currency_symbol ;

			    	$lines_html = '';
					$values     = (array) $box['lines'];
					if( is_array($values) && count($values)>0 ){
						foreach ( $values as $data ) {

							$lines_html .= isset( $data['label2'] ) ? '<li class="tm-staticbox-line">'.$data['label2'].'</li>' : '';
						}
					}
				$button = '';
					if( !empty($box['_btn_text']) && !empty($box['_btn_link']['url']) ){
						$button = '<div class="tm-vc_btn3-container tm-vc_btn3-inline"><div class="tm-vc_general tm-vc_btn3 tm-vc_btn3-size-md tm-vc_btn3-shape-square tm-vc_btn3-style-flat tm-vc_btn3-weight-no tm-vc_btn3-color-grey">' . tm_link_render($box['_btn_link'], 'start' ) . themetechmount_wp_kses($box['_btn_text']) . tm_link_render($box['_btn_link'], 'end' ) . '</div></div>';
					}


					$icon = '';
					if( !empty($box['icon_type']) ){

						 if($box['icon_type']=='image' ){
							$icon_image = '<img src="'.esc_url($box['icon_image']['url']).'" alt="'.esc_attr($box['label']).'" />';
							$icon = '<div class="tm-info-imagebox"><div class="tm-ptable-icon-type-image">' . $icon_image . '</div></div>';
							$icon_type_class = 'image';
						} else if( $box['icon_type']=='none' ){
							$icon = '';
							$icon_type_class = 'none';
						} else {
							$icon       = ( !empty($box['icon']['value']) ) ? '<div class="tm-info-main-icon">
							<div class="tm-ptable-icon-wrapper"><i class="' . $box['icon']['value'] . '"></i></div></div>' : '';
							$icon_type_class = 'icon';

							wp_enqueue_style( 'elementor-icons-'.$box['icon']['library']);
						}
					}
					$return .= $col_start_div;
					ob_start();
					include( get_template_directory() . '/template-parts/stepbox2/stepbox-'.esc_attr($style).'.php' );
					$return .= ob_get_contents();
					ob_end_clean();
					$return .= $col_end_div;

		}		
		
		echo themetechmount_wp_kses($return);
		
		$end_div = ttm_element_container( array(
			'position'	=> 'end',
			'cpt'		=> 'blog',
			'data'		=> $settings
		) );
		echo themetechmount_wp_kses($end_div);
		
		?>

		</div>

	    <?php
	}

	protected function _content_template() {}

}
// Register widget
Plugin::instance()->widgets_manager->register_widget_type( new Boldman_Stepsbox2_Widget() );